/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.essences.blocks;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.NBTTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsdim.compat.RFToolsDimensionsTOPDriver;
import mcjty.rftoolsdim.modules.essences.EssencesConfig;
import mcjty.rftoolsdim.modules.essences.EssencesModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.material.Material;

public class StructureAbsorberTileEntity
extends TickingTileEntity {
    private int absorbing = 0;
    private String structureId = null;

    public StructureAbsorberTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EssencesModule.TYPE_STRUCTURE_ABSORBER.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(2.0f).m_60918_(SoundType.f_56743_).m_60955_()).tileEntitySupplier(StructureAbsorberTileEntity::new).topDriver((TOPDriver)RFToolsDimensionsTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsdim:dimlets/dimlet_workbench")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"block", StructureAbsorberTileEntity::getStructureName), TooltipBuilder.parameter((String)"progress", StructureAbsorberTileEntity::getProgressName)})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }
        };
    }

    private static String getStructureName(ItemStack stack) {
        String structure = (String)NBTTools.getInfoNBT((ItemStack)stack, CompoundTag::m_128461_, (String)"structure", null);
        if (structure == null) {
            return "<Not Set>";
        }
        ResourceLocation id = new ResourceLocation(structure);
        return id.m_135815_();
    }

    public static String getStructure(ItemStack stack) {
        return (String)NBTTools.getInfoNBT((ItemStack)stack, CompoundTag::m_128461_, (String)"structure", null);
    }

    private static String getProgressName(ItemStack stack) {
        int absorbing = (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundTag::m_128451_, (String)"absorbing", (Object)-1);
        if (absorbing == -1) {
            return "n.a.";
        }
        int pct = ((Integer)EssencesConfig.maxStructureAbsorption.get() - absorbing) * 100 / (Integer)EssencesConfig.maxStructureAbsorption.get();
        return pct + "%";
    }

    public static int getProgress(ItemStack stack) {
        int absorbing = (Integer)NBTTools.getInfoNBT((ItemStack)stack, CompoundTag::m_128451_, (String)"absorbing", (Object)-1);
        if (absorbing == -1) {
            return -1;
        }
        return ((Integer)EssencesConfig.maxStructureAbsorption.get() - absorbing) * 100 / (Integer)EssencesConfig.maxStructureAbsorption.get();
    }

    protected void tickClient() {
        if (this.absorbing > 0) {
            Random rand = this.f_58857_.f_46441_;
            double u = rand.nextFloat() * 2.0f - 1.0f;
            double v = (float)((double)(rand.nextFloat() * 2.0f) * Math.PI);
            double x = Math.sqrt(1.0 - u * u) * Math.cos(v);
            double y = Math.sqrt(1.0 - u * u) * Math.sin(v);
            double z = u;
            double r = 1.0;
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, (double)((float)this.m_58899_().m_123341_() + 0.5f) + x * r, (double)((float)this.m_58899_().m_123342_() + 0.5f) + y * r, (double)((float)this.m_58899_().m_123343_() + 0.5f) + z * r, -x, -y, -z);
        }
    }

    public int getAbsorbing() {
        return this.absorbing;
    }

    public String getAbsorbingStructure() {
        return this.structureId;
    }

    protected void tickServer() {
        if (this.structureId == null) {
            ChunkPos cp = new ChunkPos(this.f_58858_);
            Map references = this.f_58857_.m_6325_(cp.f_45578_, cp.f_45579_).m_7049_();
            ArrayList<ResourceLocation> structures = new ArrayList<ResourceLocation>();
            for (Map.Entry entry : references.entrySet()) {
                if (((LongSet)entry.getValue()).isEmpty()) continue;
                structures.add(Tools.getId((StructureFeature)((ConfiguredStructureFeature)entry.getKey()).f_65403_));
            }
            if (!structures.isEmpty()) {
                this.structureId = structures.size() == 1 ? ((ResourceLocation)structures.get(0)).toString() : ((ResourceLocation)structures.get(this.f_58857_.f_46441_.nextInt(structures.size()))).toString();
                this.absorbing = (Integer)EssencesConfig.maxStructureAbsorption.get();
                this.m_6596_();
            }
        }
        if (this.absorbing > 0) {
            if (!this.isValidStructure()) {
                return;
            }
            --this.absorbing;
            this.m_6596_();
        }
    }

    private boolean isValidStructure() {
        ChunkPos cp = new ChunkPos(this.f_58858_);
        Map references = this.f_58857_.m_6325_(cp.f_45578_, cp.f_45579_).m_7049_();
        for (Map.Entry entry : references.entrySet()) {
            if (((LongSet)entry.getValue()).isEmpty() || !this.structureId.equals(Tools.getId((StructureFeature)((ConfiguredStructureFeature)entry.getKey()).f_65403_).toString())) continue;
            return true;
        }
        return false;
    }

    public void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128405_("absorbing", this.absorbing);
        if (this.structureId != null) {
            info.m_128359_("structure", this.structureId);
        }
    }

    public void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.absorbing = info.m_128451_("absorbing");
        this.structureId = info.m_128441_("structure") ? info.m_128461_("structure") : null;
    }
}

